package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum DefenderSecurityCenterITContactDisplayType implements Enum {

    @JsonProperty("notConfigured")
    NOT_CONFIGURED("notConfigured", "0"),

    @JsonProperty("displayInAppAndInNotifications")
    DISPLAY_IN_APP_AND_IN_NOTIFICATIONS("displayInAppAndInNotifications", "1"),

    @JsonProperty("displayOnlyInApp")
    DISPLAY_ONLY_IN_APP("displayOnlyInApp", "2"),

    @JsonProperty("displayOnlyInNotifications")
    DISPLAY_ONLY_IN_NOTIFICATIONS("displayOnlyInNotifications", "3");

    private final String name;
    private final String value;

    private DefenderSecurityCenterITContactDisplayType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
