package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum DefenderPromptForSampleSubmission implements Enum {

    @JsonProperty("userDefined")
    USER_DEFINED("userDefined", "0"),

    @JsonProperty("alwaysPrompt")
    ALWAYS_PROMPT("alwaysPrompt", "1"),

    @JsonProperty("promptBeforeSendingPersonalData")
    PROMPT_BEFORE_SENDING_PERSONAL_DATA("promptBeforeSendingPersonalData", "2"),

    @JsonProperty("neverSendData")
    NEVER_SEND_DATA("neverSendData", "3"),

    @JsonProperty("sendAllDataWithoutPrompting")
    SEND_ALL_DATA_WITHOUT_PROMPTING("sendAllDataWithoutPrompting", "4");

    private final String name;
    private final String value;

    private DefenderPromptForSampleSubmission(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
