package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum DefenderAttackSurfaceType implements Enum {

    @JsonProperty("userDefined")
    USER_DEFINED("userDefined", "0"),

    @JsonProperty("block")
    BLOCK("block", "1"),

    @JsonProperty("auditMode")
    AUDIT_MODE("auditMode", "2"),

    @JsonProperty("warn")
    WARN("warn", "6"),

    @JsonProperty("disable")
    DISABLE("disable", "99");

    private final String name;
    private final String value;

    private DefenderAttackSurfaceType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
