package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum DayOfWeek implements Enum {

    @JsonProperty("sunday")
    SUNDAY("sunday", "0"),

    @JsonProperty("monday")
    MONDAY("monday", "1"),

    @JsonProperty("tuesday")
    TUESDAY("tuesday", "2"),

    @JsonProperty("wednesday")
    WEDNESDAY("wednesday", "3"),

    @JsonProperty("thursday")
    THURSDAY("thursday", "4"),

    @JsonProperty("friday")
    FRIDAY("friday", "5"),

    @JsonProperty("saturday")
    SATURDAY("saturday", "6");

    private final String name;
    private final String value;

    private DayOfWeek(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
