package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum DataSubjectType implements Enum {

    @JsonProperty("customer")
    CUSTOMER("customer", "0"),

    @JsonProperty("currentEmployee")
    CURRENT_EMPLOYEE("currentEmployee", "1"),

    @JsonProperty("formerEmployee")
    FORMER_EMPLOYEE("formerEmployee", "2"),

    @JsonProperty("prospectiveEmployee")
    PROSPECTIVE_EMPLOYEE("prospectiveEmployee", "3"),

    @JsonProperty("student")
    STUDENT("student", "4"),

    @JsonProperty("teacher")
    TEACHER("teacher", "5"),

    @JsonProperty("faculty")
    FACULTY("faculty", "6"),

    @JsonProperty("other")
    OTHER("other", "7"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "8");

    private final String name;
    private final String value;

    private DataSubjectType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
