package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum CrossTenantAccessPolicyTargetType implements Enum {

    @JsonProperty("user")
    USER("user", "1"),

    @JsonProperty("group")
    GROUP("group", "2"),

    @JsonProperty("application")
    APPLICATION("application", "3"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "4");

    private final String name;
    private final String value;

    private CrossTenantAccessPolicyTargetType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
