package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ConfigurationUsage implements Enum {

    @JsonProperty("blocked")
    BLOCKED("blocked", "0"),

    @JsonProperty("required")
    REQUIRED("required", "1"),

    @JsonProperty("allowed")
    ALLOWED("allowed", "2"),

    @JsonProperty("notConfigured")
    NOT_CONFIGURED("notConfigured", "3");

    private final String name;
    private final String value;

    private ConfigurationUsage(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
