package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ConditionalAccessPolicyState implements Enum {

    @JsonProperty("enabled")
    ENABLED("enabled", "0"),

    @JsonProperty("disabled")
    DISABLED("disabled", "1"),

    @JsonProperty("enabledForReportingButNotEnforced")
    ENABLED_FOR_REPORTING_BUT_NOT_ENFORCED("enabledForReportingButNotEnforced", "2");

    private final String name;
    private final String value;

    private ConditionalAccessPolicyState(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
