package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ComplianceStatus implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("notApplicable")
    NOT_APPLICABLE("notApplicable", "1"),

    @JsonProperty("compliant")
    COMPLIANT("compliant", "2"),

    @JsonProperty("remediated")
    REMEDIATED("remediated", "3"),

    @JsonProperty("nonCompliant")
    NON_COMPLIANT("nonCompliant", "4"),

    @JsonProperty("error")
    ERROR("error", "5"),

    @JsonProperty("conflict")
    CONFLICT("conflict", "6"),

    @JsonProperty("notAssigned")
    NOT_ASSIGNED("notAssigned", "7");

    private final String name;
    private final String value;

    private ComplianceStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
