package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ComplianceState implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("compliant")
    COMPLIANT("compliant", "1"),

    @JsonProperty("noncompliant")
    NONCOMPLIANT("noncompliant", "2"),

    @JsonProperty("conflict")
    CONFLICT("conflict", "3"),

    @JsonProperty("error")
    ERROR("error", "4"),

    @JsonProperty("inGracePeriod")
    IN_GRACE_PERIOD("inGracePeriod", "254"),

    @JsonProperty("configManager")
    CONFIG_MANAGER("configManager", "255");

    private final String name;
    private final String value;

    private ComplianceState(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
