package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum Code implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("jsonFileInvalid")
    JSON_FILE_INVALID("jsonFileInvalid", "1"),

    @JsonProperty("jsonFileMissing")
    JSON_FILE_MISSING("jsonFileMissing", "2"),

    @JsonProperty("jsonFileTooLarge")
    JSON_FILE_TOO_LARGE("jsonFileTooLarge", "3"),

    @JsonProperty("rulesMissing")
    RULES_MISSING("rulesMissing", "4"),

    @JsonProperty("duplicateRules")
    DUPLICATE_RULES("duplicateRules", "5"),

    @JsonProperty("tooManyRulesSpecified")
    TOO_MANY_RULES_SPECIFIED("tooManyRulesSpecified", "6"),

    @JsonProperty("operatorMissing")
    OPERATOR_MISSING("operatorMissing", "7"),

    @JsonProperty("operatorNotSupported")
    OPERATOR_NOT_SUPPORTED("operatorNotSupported", "8"),

    @JsonProperty("datatypeMissing")
    DATATYPE_MISSING("datatypeMissing", "9"),

    @JsonProperty("datatypeNotSupported")
    DATATYPE_NOT_SUPPORTED("datatypeNotSupported", "10"),

    @JsonProperty("operatorDataTypeCombinationNotSupported")
    OPERATOR_DATA_TYPE_COMBINATION_NOT_SUPPORTED("operatorDataTypeCombinationNotSupported", "11"),

    @JsonProperty("moreInfoUriMissing")
    MORE_INFO_URI_MISSING("moreInfoUriMissing", "12"),

    @JsonProperty("moreInfoUriInvalid")
    MORE_INFO_URI_INVALID("moreInfoUriInvalid", "13"),

    @JsonProperty("moreInfoUriTooLarge")
    MORE_INFO_URI_TOO_LARGE("moreInfoUriTooLarge", "14"),

    @JsonProperty("descriptionMissing")
    DESCRIPTION_MISSING("descriptionMissing", "15"),

    @JsonProperty("descriptionInvalid")
    DESCRIPTION_INVALID("descriptionInvalid", "16"),

    @JsonProperty("descriptionTooLarge")
    DESCRIPTION_TOO_LARGE("descriptionTooLarge", "17"),

    @JsonProperty("titleMissing")
    TITLE_MISSING("titleMissing", "18"),

    @JsonProperty("titleInvalid")
    TITLE_INVALID("titleInvalid", "19"),

    @JsonProperty("titleTooLarge")
    TITLE_TOO_LARGE("titleTooLarge", "20"),

    @JsonProperty("operandMissing")
    OPERAND_MISSING("operandMissing", "21"),

    @JsonProperty("operandInvalid")
    OPERAND_INVALID("operandInvalid", "22"),

    @JsonProperty("operandTooLarge")
    OPERAND_TOO_LARGE("operandTooLarge", "23"),

    @JsonProperty("settingNameMissing")
    SETTING_NAME_MISSING("settingNameMissing", "24"),

    @JsonProperty("settingNameInvalid")
    SETTING_NAME_INVALID("settingNameInvalid", "25"),

    @JsonProperty("settingNameTooLarge")
    SETTING_NAME_TOO_LARGE("settingNameTooLarge", "26"),

    @JsonProperty("englishLocaleMissing")
    ENGLISH_LOCALE_MISSING("englishLocaleMissing", "27"),

    @JsonProperty("duplicateLocales")
    DUPLICATE_LOCALES("duplicateLocales", "28"),

    @JsonProperty("unrecognizedLocale")
    UNRECOGNIZED_LOCALE("unrecognizedLocale", "29"),

    @JsonProperty("unknown")
    UNKNOWN("unknown", "30"),

    @JsonProperty("remediationStringsMissing")
    REMEDIATION_STRINGS_MISSING("remediationStringsMissing", "31");

    private final String name;
    private final String value;

    private Code(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
