package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum CloudPcStatus implements Enum {

    @JsonProperty("notProvisioned")
    NOT_PROVISIONED("notProvisioned", "0"),

    @JsonProperty("provisioning")
    PROVISIONING("provisioning", "1"),

    @JsonProperty("provisioned")
    PROVISIONED("provisioned", "2"),

    @JsonProperty("inGracePeriod")
    IN_GRACE_PERIOD("inGracePeriod", "3"),

    @JsonProperty("deprovisioning")
    DEPROVISIONING("deprovisioning", "4"),

    @JsonProperty("failed")
    FAILED("failed", "5"),

    @JsonProperty("provisionedWithWarnings")
    PROVISIONED_WITH_WARNINGS("provisionedWithWarnings", "6"),

    @JsonProperty("resizing")
    RESIZING("resizing", "7"),

    @JsonProperty("restoring")
    RESTORING("restoring", "8"),

    @JsonProperty("pendingProvision")
    PENDING_PROVISION("pendingProvision", "9"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "999");

    private final String name;
    private final String value;

    private CloudPcStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
