package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum CloudPcOnPremisesConnectionType implements Enum {

    @JsonProperty("hybridAzureADJoin")
    HYBRID_AZURE_ADJOIN("hybridAzureADJoin", "0"),

    @JsonProperty("azureADJoin")
    AZURE_ADJOIN("azureADJoin", "1"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "999");

    private final String name;
    private final String value;

    private CloudPcOnPremisesConnectionType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
