package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum CloudPcDeviceImageOsStatus implements Enum {

    @JsonProperty("supported")
    SUPPORTED("supported", "0"),

    @JsonProperty("supportedWithWarning")
    SUPPORTED_WITH_WARNING("supportedWithWarning", "1"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "999");

    private final String name;
    private final String value;

    private CloudPcDeviceImageOsStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
