package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum CloudPcAuditCategory implements Enum {

    @JsonProperty("cloudPC")
    CLOUD_PC("cloudPC", "0"),

    @JsonProperty("other")
    OTHER("other", "999");

    private final String name;
    private final String value;

    private CloudPcAuditCategory(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
