package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum CloudPcAuditActorType implements Enum {

    @JsonProperty("itPro")
    IT_PRO("itPro", "0"),

    @JsonProperty("application")
    APPLICATION("application", "1"),

    @JsonProperty("partner")
    PARTNER("partner", "2"),

    @JsonProperty("unknown")
    UNKNOWN("unknown", "999");

    private final String name;
    private final String value;

    private CloudPcAuditActorType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
