package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum CertificateIssuanceStates implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("challengeIssued")
    CHALLENGE_ISSUED("challengeIssued", "1"),

    @JsonProperty("challengeIssueFailed")
    CHALLENGE_ISSUE_FAILED("challengeIssueFailed", "2"),

    @JsonProperty("requestCreationFailed")
    REQUEST_CREATION_FAILED("requestCreationFailed", "3"),

    @JsonProperty("requestSubmitFailed")
    REQUEST_SUBMIT_FAILED("requestSubmitFailed", "4"),

    @JsonProperty("challengeValidationSucceeded")
    CHALLENGE_VALIDATION_SUCCEEDED("challengeValidationSucceeded", "5"),

    @JsonProperty("challengeValidationFailed")
    CHALLENGE_VALIDATION_FAILED("challengeValidationFailed", "6"),

    @JsonProperty("issueFailed")
    ISSUE_FAILED("issueFailed", "7"),

    @JsonProperty("issuePending")
    ISSUE_PENDING("issuePending", "8"),

    @JsonProperty("issued")
    ISSUED("issued", "9"),

    @JsonProperty("responseProcessingFailed")
    RESPONSE_PROCESSING_FAILED("responseProcessingFailed", "10"),

    @JsonProperty("responsePending")
    RESPONSE_PENDING("responsePending", "11"),

    @JsonProperty("enrollmentSucceeded")
    ENROLLMENT_SUCCEEDED("enrollmentSucceeded", "12"),

    @JsonProperty("enrollmentNotNeeded")
    ENROLLMENT_NOT_NEEDED("enrollmentNotNeeded", "13"),

    @JsonProperty("revoked")
    REVOKED("revoked", "14"),

    @JsonProperty("removedFromCollection")
    REMOVED_FROM_COLLECTION("removedFromCollection", "15"),

    @JsonProperty("renewVerified")
    RENEW_VERIFIED("renewVerified", "16"),

    @JsonProperty("installFailed")
    INSTALL_FAILED("installFailed", "17"),

    @JsonProperty("installed")
    INSTALLED("installed", "18"),

    @JsonProperty("deleteFailed")
    DELETE_FAILED("deleteFailed", "19"),

    @JsonProperty("deleted")
    DELETED("deleted", "20"),

    @JsonProperty("renewalRequested")
    RENEWAL_REQUESTED("renewalRequested", "21"),

    @JsonProperty("requested")
    REQUESTED("requested", "22");

    private final String name;
    private final String value;

    private CertificateIssuanceStates(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
