package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum CertificateDestinationStore implements Enum {

    @JsonProperty("computerCertStoreRoot")
    COMPUTER_CERT_STORE_ROOT("computerCertStoreRoot", "0"),

    @JsonProperty("computerCertStoreIntermediate")
    COMPUTER_CERT_STORE_INTERMEDIATE("computerCertStoreIntermediate", "1"),

    @JsonProperty("userCertStoreIntermediate")
    USER_CERT_STORE_INTERMEDIATE("userCertStoreIntermediate", "2");

    private final String name;
    private final String value;

    private CertificateDestinationStore(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
