package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum CallRecordingStatus implements Enum {

    @JsonProperty("success")
    SUCCESS("success", "0"),

    @JsonProperty("failure")
    FAILURE("failure", "1"),

    @JsonProperty("initial")
    INITIAL("initial", "2"),

    @JsonProperty("chunkFinished")
    CHUNK_FINISHED("chunkFinished", "3"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "4");

    private final String name;
    private final String value;

    private CallRecordingStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
