package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum CalendarRoleType implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("freeBusyRead")
    FREE_BUSY_READ("freeBusyRead", "1"),

    @JsonProperty("limitedRead")
    LIMITED_READ("limitedRead", "2"),

    @JsonProperty("read")
    READ("read", "3"),

    @JsonProperty("write")
    WRITE("write", "4"),

    @JsonProperty("delegateWithoutPrivateEventAccess")
    DELEGATE_WITHOUT_PRIVATE_EVENT_ACCESS("delegateWithoutPrivateEventAccess", "5"),

    @JsonProperty("delegateWithPrivateEventAccess")
    DELEGATE_WITH_PRIVATE_EVENT_ACCESS("delegateWithPrivateEventAccess", "6"),

    @JsonProperty("custom")
    CUSTOM("custom", "7");

    private final String name;
    private final String value;

    private CalendarRoleType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
