package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum CalendarColor implements Enum {

    @JsonProperty("auto")
    AUTO("auto", "-1"),

    @JsonProperty("lightBlue")
    LIGHT_BLUE("lightBlue", "0"),

    @JsonProperty("lightGreen")
    LIGHT_GREEN("lightGreen", "1"),

    @JsonProperty("lightOrange")
    LIGHT_ORANGE("lightOrange", "2"),

    @JsonProperty("lightGray")
    LIGHT_GRAY("lightGray", "3"),

    @JsonProperty("lightYellow")
    LIGHT_YELLOW("lightYellow", "4"),

    @JsonProperty("lightTeal")
    LIGHT_TEAL("lightTeal", "5"),

    @JsonProperty("lightPink")
    LIGHT_PINK("lightPink", "6"),

    @JsonProperty("lightBrown")
    LIGHT_BROWN("lightBrown", "7"),

    @JsonProperty("lightRed")
    LIGHT_RED("lightRed", "8"),

    @JsonProperty("maxColor")
    MAX_COLOR("maxColor", "9");

    private final String name;
    private final String value;

    private CalendarColor(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
