package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum BucketAggregationSortProperty implements Enum {

    @JsonProperty("count")
    COUNT("count", "0"),

    @JsonProperty("keyAsString")
    KEY_AS_STRING("keyAsString", "1"),

    @JsonProperty("keyAsNumber")
    KEY_AS_NUMBER("keyAsNumber", "2"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "3");

    private final String name;
    private final String value;

    private BucketAggregationSortProperty(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
