package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum BookingPriceType implements Enum {

    @JsonProperty("undefined")
    UNDEFINED("undefined", "0"),

    @JsonProperty("fixedPrice")
    FIXED_PRICE("fixedPrice", "1"),

    @JsonProperty("startingAt")
    STARTING_AT("startingAt", "2"),

    @JsonProperty("hourly")
    HOURLY("hourly", "3"),

    @JsonProperty("free")
    FREE("free", "4"),

    @JsonProperty("priceVaries")
    PRICE_VARIES("priceVaries", "5"),

    @JsonProperty("callUs")
    CALL_US("callUs", "6"),

    @JsonProperty("notSet")
    NOT_SET("notSet", "7");

    private final String name;
    private final String value;

    private BookingPriceType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
