package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum BookingInvoiceStatus implements Enum {

    @JsonProperty("draft")
    DRAFT("draft", "0"),

    @JsonProperty("reviewing")
    REVIEWING("reviewing", "1"),

    @JsonProperty("open")
    OPEN("open", "2"),

    @JsonProperty("canceled")
    CANCELED("canceled", "3"),

    @JsonProperty("paid")
    PAID("paid", "4"),

    @JsonProperty("corrective")
    CORRECTIVE("corrective", "5");

    private final String name;
    private final String value;

    private BookingInvoiceStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
