package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum AutomaticUpdateMode implements Enum {

    @JsonProperty("userDefined")
    USER_DEFINED("userDefined", "0"),

    @JsonProperty("notifyDownload")
    NOTIFY_DOWNLOAD("notifyDownload", "1"),

    @JsonProperty("autoInstallAtMaintenanceTime")
    AUTO_INSTALL_AT_MAINTENANCE_TIME("autoInstallAtMaintenanceTime", "2"),

    @JsonProperty("autoInstallAndRebootAtMaintenanceTime")
    AUTO_INSTALL_AND_REBOOT_AT_MAINTENANCE_TIME("autoInstallAndRebootAtMaintenanceTime", "3"),

    @JsonProperty("autoInstallAndRebootAtScheduledTime")
    AUTO_INSTALL_AND_REBOOT_AT_SCHEDULED_TIME("autoInstallAndRebootAtScheduledTime", "4"),

    @JsonProperty("autoInstallAndRebootWithoutEndUserControl")
    AUTO_INSTALL_AND_REBOOT_WITHOUT_END_USER_CONTROL("autoInstallAndRebootWithoutEndUserControl", "5"),

    @JsonProperty("windowsDefault")
    WINDOWS_DEFAULT("windowsDefault", "6");

    private final String name;
    private final String value;

    private AutomaticUpdateMode(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
