package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum AutomaticRepliesStatus implements Enum {

    @JsonProperty("disabled")
    DISABLED("disabled", "0"),

    @JsonProperty("alwaysEnabled")
    ALWAYS_ENABLED("alwaysEnabled", "1"),

    @JsonProperty("scheduled")
    SCHEDULED("scheduled", "2");

    private final String name;
    private final String value;

    private AutomaticRepliesStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
