package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum AuthenticationMethodFeature implements Enum {

    @JsonProperty("ssprRegistered")
    SSPR_REGISTERED("ssprRegistered", "0"),

    @JsonProperty("ssprEnabled")
    SSPR_ENABLED("ssprEnabled", "1"),

    @JsonProperty("ssprCapable")
    SSPR_CAPABLE("ssprCapable", "2"),

    @JsonProperty("passwordlessCapable")
    PASSWORDLESS_CAPABLE("passwordlessCapable", "3"),

    @JsonProperty("mfaCapable")
    MFA_CAPABLE("mfaCapable", "4");

    private final String name;
    private final String value;

    private AuthenticationMethodFeature(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
