package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum AttributeType implements Enum {

    @JsonProperty("String")
    STRING("String", "0"),

    @JsonProperty("Integer")
    INTEGER("Integer", "1"),

    @JsonProperty("Reference")
    REFERENCE("Reference", "2"),

    @JsonProperty("Binary")
    BINARY("Binary", "3"),

    @JsonProperty("Boolean")
    BOOLEAN("Boolean", "4"),

    @JsonProperty("DateTime")
    DATE_TIME("DateTime", "5");

    private final String name;
    private final String value;

    private AttributeType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
