package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum AssignmentFilterEvaluationResult implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("match")
    MATCH("match", "1"),

    @JsonProperty("notMatch")
    NOT_MATCH("notMatch", "2"),

    @JsonProperty("inconclusive")
    INCONCLUSIVE("inconclusive", "3"),

    @JsonProperty("failure")
    FAILURE("failure", "4"),

    @JsonProperty("notEvaluated")
    NOT_EVALUATED("notEvaluated", "5");

    private final String name;
    private final String value;

    private AssignmentFilterEvaluationResult(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
