package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ApplicationMode implements Enum {

    @JsonProperty("manual")
    MANUAL("manual", "0"),

    @JsonProperty("automatic")
    AUTOMATIC("automatic", "1"),

    @JsonProperty("recommended")
    RECOMMENDED("recommended", "2");

    private final String name;
    private final String value;

    private ApplicationMode(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
