package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ApplicationGuardBlockFileTransferType implements Enum {

    @JsonProperty("notConfigured")
    NOT_CONFIGURED("notConfigured", "0"),

    @JsonProperty("blockImageAndTextFile")
    BLOCK_IMAGE_AND_TEXT_FILE("blockImageAndTextFile", "1"),

    @JsonProperty("blockImageFile")
    BLOCK_IMAGE_FILE("blockImageFile", "2"),

    @JsonProperty("blockNone")
    BLOCK_NONE("blockNone", "3"),

    @JsonProperty("blockTextFile")
    BLOCK_TEXT_FILE("blockTextFile", "4");

    private final String name;
    private final String value;

    private ApplicationGuardBlockFileTransferType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
