package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ApplicationGuardBlockClipboardSharingType implements Enum {

    @JsonProperty("notConfigured")
    NOT_CONFIGURED("notConfigured", "0"),

    @JsonProperty("blockBoth")
    BLOCK_BOTH("blockBoth", "1"),

    @JsonProperty("blockHostToContainer")
    BLOCK_HOST_TO_CONTAINER("blockHostToContainer", "2"),

    @JsonProperty("blockContainerToHost")
    BLOCK_CONTAINER_TO_HOST("blockContainerToHost", "3"),

    @JsonProperty("blockNone")
    BLOCK_NONE("blockNone", "4");

    private final String name;
    private final String value;

    private ApplicationGuardBlockClipboardSharingType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
