package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum AppLockerApplicationControlType implements Enum {

    @JsonProperty("notConfigured")
    NOT_CONFIGURED("notConfigured", "0"),

    @JsonProperty("enforceComponentsAndStoreApps")
    ENFORCE_COMPONENTS_AND_STORE_APPS("enforceComponentsAndStoreApps", "1"),

    @JsonProperty("auditComponentsAndStoreApps")
    AUDIT_COMPONENTS_AND_STORE_APPS("auditComponentsAndStoreApps", "2"),

    @JsonProperty("enforceComponentsStoreAppsAndSmartlocker")
    ENFORCE_COMPONENTS_STORE_APPS_AND_SMARTLOCKER("enforceComponentsStoreAppsAndSmartlocker", "3"),

    @JsonProperty("auditComponentsStoreAppsAndSmartlocker")
    AUDIT_COMPONENTS_STORE_APPS_AND_SMARTLOCKER("auditComponentsStoreAppsAndSmartlocker", "4");

    private final String name;
    private final String value;

    private AppLockerApplicationControlType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
