package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum AndroidWorkProfileVpnConnectionType implements Enum {

    @JsonProperty("ciscoAnyConnect")
    CISCO_ANY_CONNECT("ciscoAnyConnect", "0"),

    @JsonProperty("pulseSecure")
    PULSE_SECURE("pulseSecure", "1"),

    @JsonProperty("f5EdgeClient")
    F5EDGE_CLIENT("f5EdgeClient", "2"),

    @JsonProperty("dellSonicWallMobileConnect")
    DELL_SONIC_WALL_MOBILE_CONNECT("dellSonicWallMobileConnect", "3"),

    @JsonProperty("checkPointCapsuleVpn")
    CHECK_POINT_CAPSULE_VPN("checkPointCapsuleVpn", "4"),

    @JsonProperty("citrix")
    CITRIX("citrix", "5"),

    @JsonProperty("paloAltoGlobalProtect")
    PALO_ALTO_GLOBAL_PROTECT("paloAltoGlobalProtect", "6"),

    @JsonProperty("microsoftTunnel")
    MICROSOFT_TUNNEL("microsoftTunnel", "7"),

    @JsonProperty("netMotionMobility")
    NET_MOTION_MOBILITY("netMotionMobility", "8"),

    @JsonProperty("microsoftProtect")
    MICROSOFT_PROTECT("microsoftProtect", "9");

    private final String name;
    private final String value;

    private AndroidWorkProfileVpnConnectionType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
