package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum AndroidWiFiSecurityType implements Enum {

    @JsonProperty("open")
    OPEN("open", "0"),

    @JsonProperty("wpaEnterprise")
    WPA_ENTERPRISE("wpaEnterprise", "1"),

    @JsonProperty("wpa2Enterprise")
    WPA2ENTERPRISE("wpa2Enterprise", "2");

    private final String name;
    private final String value;

    private AndroidWiFiSecurityType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
