package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum AndroidRequiredPasswordType implements Enum {

    @JsonProperty("deviceDefault")
    DEVICE_DEFAULT("deviceDefault", "0"),

    @JsonProperty("alphabetic")
    ALPHABETIC("alphabetic", "1"),

    @JsonProperty("alphanumeric")
    ALPHANUMERIC("alphanumeric", "2"),

    @JsonProperty("alphanumericWithSymbols")
    ALPHANUMERIC_WITH_SYMBOLS("alphanumericWithSymbols", "3"),

    @JsonProperty("lowSecurityBiometric")
    LOW_SECURITY_BIOMETRIC("lowSecurityBiometric", "4"),

    @JsonProperty("numeric")
    NUMERIC("numeric", "5"),

    @JsonProperty("numericComplex")
    NUMERIC_COMPLEX("numericComplex", "6"),

    @JsonProperty("any")
    ANY("any", "7");

    private final String name;
    private final String value;

    private AndroidRequiredPasswordType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
