package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum AndroidManagedStoreAppConfigurationSchemaItemDataType implements Enum {

    @JsonProperty("bool")
    BOOL("bool", "0"),

    @JsonProperty("integer")
    INTEGER("integer", "1"),

    @JsonProperty("string")
    STRING("string", "2"),

    @JsonProperty("choice")
    CHOICE("choice", "3"),

    @JsonProperty("multiselect")
    MULTISELECT("multiselect", "4"),

    @JsonProperty("bundle")
    BUNDLE("bundle", "5"),

    @JsonProperty("bundleArray")
    BUNDLE_ARRAY("bundleArray", "6"),

    @JsonProperty("hidden")
    HIDDEN("hidden", "7");

    private final String name;
    private final String value;

    private AndroidManagedStoreAppConfigurationSchemaItemDataType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
