package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum AndroidForWorkEnrollmentTarget implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("all")
    ALL("all", "1"),

    @JsonProperty("targeted")
    TARGETED("targeted", "2"),

    @JsonProperty("targetedAsEnrollmentRestrictions")
    TARGETED_AS_ENROLLMENT_RESTRICTIONS("targetedAsEnrollmentRestrictions", "3");

    private final String name;
    private final String value;

    private AndroidForWorkEnrollmentTarget(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
