package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum AndroidDeviceOwnerSystemUpdateInstallType implements Enum {

    @JsonProperty("deviceDefault")
    DEVICE_DEFAULT("deviceDefault", "0"),

    @JsonProperty("postpone")
    POSTPONE("postpone", "1"),

    @JsonProperty("windowed")
    WINDOWED("windowed", "2"),

    @JsonProperty("automatic")
    AUTOMATIC("automatic", "3");

    private final String name;
    private final String value;

    private AndroidDeviceOwnerSystemUpdateInstallType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
