package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum AndroidDeviceOwnerEnrollmentTokenType implements Enum {

    @JsonProperty("default")
    DEFAULT("default", "0"),

    @JsonProperty("corporateOwnedDedicatedDeviceWithAzureADSharedMode")
    CORPORATE_OWNED_DEDICATED_DEVICE_WITH_AZURE_ADSHARED_MODE("corporateOwnedDedicatedDeviceWithAzureADSharedMode", "1");

    private final String name;
    private final String value;

    private AndroidDeviceOwnerEnrollmentTokenType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
