package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum AndroidDeviceOwnerEnrollmentMode implements Enum {

    @JsonProperty("corporateOwnedDedicatedDevice")
    CORPORATE_OWNED_DEDICATED_DEVICE("corporateOwnedDedicatedDevice", "0"),

    @JsonProperty("corporateOwnedFullyManaged")
    CORPORATE_OWNED_FULLY_MANAGED("corporateOwnedFullyManaged", "1"),

    @JsonProperty("corporateOwnedWorkProfile")
    CORPORATE_OWNED_WORK_PROFILE("corporateOwnedWorkProfile", "2"),

    @JsonProperty("corporateOwnedAOSPUserlessDevice")
    CORPORATE_OWNED_AOSPUSERLESS_DEVICE("corporateOwnedAOSPUserlessDevice", "3"),

    @JsonProperty("corporateOwnedAOSPUserAssociatedDevice")
    CORPORATE_OWNED_AOSPUSER_ASSOCIATED_DEVICE("corporateOwnedAOSPUserAssociatedDevice", "4");

    private final String name;
    private final String value;

    private AndroidDeviceOwnerEnrollmentMode(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
