package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum AndroidDeviceOwnerDefaultAppPermissionPolicyType implements Enum {

    @JsonProperty("deviceDefault")
    DEVICE_DEFAULT("deviceDefault", "0"),

    @JsonProperty("prompt")
    PROMPT("prompt", "1"),

    @JsonProperty("autoGrant")
    AUTO_GRANT("autoGrant", "2"),

    @JsonProperty("autoDeny")
    AUTO_DENY("autoDeny", "3");

    private final String name;
    private final String value;

    private AndroidDeviceOwnerDefaultAppPermissionPolicyType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
