package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum AndroidDeviceOwnerAppAutoUpdatePolicyType implements Enum {

    @JsonProperty("notConfigured")
    NOT_CONFIGURED("notConfigured", "0"),

    @JsonProperty("userChoice")
    USER_CHOICE("userChoice", "1"),

    @JsonProperty("never")
    NEVER("never", "2"),

    @JsonProperty("wiFiOnly")
    WI_FI_ONLY("wiFiOnly", "3"),

    @JsonProperty("always")
    ALWAYS("always", "4");

    private final String name;
    private final String value;

    private AndroidDeviceOwnerAppAutoUpdatePolicyType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
