package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum AccessReviewTimeoutBehavior implements Enum {

    @JsonProperty("keepAccess")
    KEEP_ACCESS("keepAccess", "0"),

    @JsonProperty("removeAccess")
    REMOVE_ACCESS("removeAccess", "1"),

    @JsonProperty("acceptAccessRecommendation")
    ACCEPT_ACCESS_RECOMMENDATION("acceptAccessRecommendation", "2"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "99");

    private final String name;
    private final String value;

    private AccessReviewTimeoutBehavior(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
