package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum AccessReviewHistoryStatus implements Enum {

    @JsonProperty("done")
    DONE("done", "0"),

    @JsonProperty("inprogress")
    INPROGRESS("inprogress", "1"),

    @JsonProperty("error")
    ERROR("error", "2"),

    @JsonProperty("requested")
    REQUESTED("requested", "3"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "4");

    private final String name;
    private final String value;

    private AccessReviewHistoryStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
