package odata.msgraph.client.beta.entity.set;

import com.github.davidmoten.odata.client.ContextPath;

import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.UserCollectionRequest;

public final class Users extends UserCollectionRequest {

    public Users(ContextPath contextPath) {
        super(contextPath, Optional.empty());
    }

    public DirectoryObjects createdObjects() {
        return new DirectoryObjects(contextPath.addSegment("createdObjects"));
    }

    public DirectoryObjects directReports() {
        return new DirectoryObjects(contextPath.addSegment("directReports"));
    }

    public Teams joinedTeams() {
        return new Teams(contextPath.addSegment("joinedTeams"));
    }

    public DirectoryObjects manager() {
        return new DirectoryObjects(contextPath.addSegment("manager"));
    }

    public DirectoryObjects memberOf() {
        return new DirectoryObjects(contextPath.addSegment("memberOf"));
    }

    public Oauth2PermissionGrants oauth2PermissionGrants() {
        return new Oauth2PermissionGrants(contextPath.addSegment("oauth2PermissionGrants"));
    }

    public DirectoryObjects ownedDevices() {
        return new DirectoryObjects(contextPath.addSegment("ownedDevices"));
    }

    public DirectoryObjects ownedObjects() {
        return new DirectoryObjects(contextPath.addSegment("ownedObjects"));
    }

    public DirectoryObjects registeredDevices() {
        return new DirectoryObjects(contextPath.addSegment("registeredDevices"));
    }

    public DirectoryObjects transitiveMemberOf() {
        return new DirectoryObjects(contextPath.addSegment("transitiveMemberOf"));
    }

    public DirectoryObjects transitiveReports() {
        return new DirectoryObjects(contextPath.addSegment("transitiveReports"));
    }
}
