package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.X509CertificateAuthenticationMethodConfiguration;
import odata.msgraph.client.beta.entity.collection.request.AuthenticationMethodTargetCollectionRequest;

@JsonIgnoreType
public class X509CertificateAuthenticationMethodConfigurationRequest extends EntityRequest<X509CertificateAuthenticationMethodConfiguration> {

    public X509CertificateAuthenticationMethodConfigurationRequest(ContextPath contextPath, Optional<Object> value) {
        super(X509CertificateAuthenticationMethodConfiguration.class, contextPath, value, false);
    }

    public AuthenticationMethodTargetRequest includeTargets(String id) {
        return new AuthenticationMethodTargetRequest(contextPath.addSegment("includeTargets").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AuthenticationMethodTargetCollectionRequest includeTargets() {
        return new AuthenticationMethodTargetCollectionRequest(
                        contextPath.addSegment("includeTargets"), Optional.empty());
    }

}
