package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.WorkbookWorksheetProtectionOptions;
import odata.msgraph.client.beta.entity.WorkbookWorksheetProtection;

@JsonIgnoreType
public class WorkbookWorksheetProtectionRequest extends EntityRequest<WorkbookWorksheetProtection> {

    public WorkbookWorksheetProtectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(WorkbookWorksheetProtection.class, contextPath, value, false);
    }

    @Action(name = "protect")
    @JsonIgnore
    public ActionRequestNoReturn protect(WorkbookWorksheetProtectionOptions options) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("options", "microsoft.graph.workbookWorksheetProtectionOptions", options)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.protect"), _parameters);
    }

    @Action(name = "unprotect")
    @JsonIgnore
    public ActionRequestNoReturn unprotect() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.unprotect"), _parameters);
    }

}
