package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.WorkbookRangeFormat;
import odata.msgraph.client.beta.entity.collection.request.WorkbookRangeBorderCollectionRequest;

@JsonIgnoreType
public class WorkbookRangeFormatRequest extends EntityRequest<WorkbookRangeFormat> {

    public WorkbookRangeFormatRequest(ContextPath contextPath, Optional<Object> value) {
        super(WorkbookRangeFormat.class, contextPath, value, false);
    }

    public WorkbookRangeBorderRequest borders(String id) {
        return new WorkbookRangeBorderRequest(contextPath.addSegment("borders").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public WorkbookRangeBorderCollectionRequest borders() {
        return new WorkbookRangeBorderCollectionRequest(
                        contextPath.addSegment("borders"), Optional.empty());
    }

    public WorkbookRangeFillRequest fill() {
        return new WorkbookRangeFillRequest(contextPath.addSegment("fill"), Optional.empty());
    }

    public WorkbookRangeFontRequest font() {
        return new WorkbookRangeFontRequest(contextPath.addSegment("font"), Optional.empty());
    }

    public WorkbookFormatProtectionRequest protection() {
        return new WorkbookFormatProtectionRequest(contextPath.addSegment("protection"), Optional.empty());
    }

    @Action(name = "autofitColumns")
    @JsonIgnore
    public ActionRequestNoReturn autofitColumns() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.autofitColumns"), _parameters);
    }

    @Action(name = "autofitRows")
    @JsonIgnore
    public ActionRequestNoReturn autofitRows() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.autofitRows"), _parameters);
    }

}
