package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.WorkbookPivotTable;

@JsonIgnoreType
public class WorkbookPivotTableRequest extends EntityRequest<WorkbookPivotTable> {

    public WorkbookPivotTableRequest(ContextPath contextPath, Optional<Object> value) {
        super(WorkbookPivotTable.class, contextPath, value, false);
    }

    public WorkbookWorksheetRequest worksheet() {
        return new WorkbookWorksheetRequest(contextPath.addSegment("worksheet"), Optional.empty());
    }

    @Action(name = "refresh")
    @JsonIgnore
    public ActionRequestNoReturn refresh() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.refresh"), _parameters);
    }

}
